// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Ball_h__
#define __Ball_h__

#ifndef __Float_h__
#include "Float.h"
#endif

#ifndef __PhysicsObject_h__
#include "PhysicsObject.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __Color_h__
#include "Color.h"
#endif

class BoundingBox;
class BallConfiguration;
class Color;

// A ball.
// The visible part of a spherical physics object.
// We assume the first 3 state variables are the center of the visible image.
class Ball : public PhysicsObject {
  const Float m_visibleRadius;
  const Color m_material;
public:
  Ball (SP<BallConfiguration> b);
  
  inline Float visibleRadius () const {
    return m_visibleRadius;
  }

  // A subclass might want to redefine stateSize to be larger.
  virtual int stateSize () const;
  void translate (Float *state, const Vec3 &v) const;
  // Next one does nothing.
  void rotate (Float *state, const Quaternion &q) const;
  Vec3 boundingSphereCenter (const Float *state) const;
  inline static Vec3 center (const Float *state) {
    return Vec3 (state);
  }
  static void setCenter (Float *state, const Vec3 &v);
  ~Ball ();
  static const char *const staticClassId;
  Color getMaterial () const;

};

#endif
