// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "Ball.h"

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __Float_h__
#include "Float.h"
#endif

#ifndef __BallConfiguration_h__
#include "BallConfiguration.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __TheObjectDrawerFactory_h__
#include "TheObjectDrawerFactory.h"
#endif

#ifndef __Quaternion_h__
#include "Quaternion.h"
#endif

Ball::Ball (const SP<BallConfiguration> b)
  : PhysicsObject ("Ball", &*b),
    m_visibleRadius (b->getVisibleRadius ()),
    m_material (b->getMaterial ())
{
  assert (3 <= stateSize ());
}

Ball::~Ball () {
}

Color Ball::getMaterial () const {
  return m_material;
}

// x,y,z coordinates.
int Ball::stateSize () const {
  return 3;
}

static inline Float sqr (Float d) {
  return d * d;
}

inline Vec3 Ball::boundingSphereCenter (const Float *state) const {
  return Vec3 (state);
}

void Ball::setCenter (Float *state, const Vec3 &v) {
  v.copyToPointer (state);
}

// This method is const because it can only update the state.  It
// can't update the Ball object itself.
void Ball::translate (Float *state, const Vec3 &v) const {
  state [0] += v[0];
  state [1] += v[1];
  state [2] += v[2];
}

void Ball::rotate (Float *state, const Quaternion &q) const {
  (void) state; (void) q;
}

const char *const Ball::staticClassId = "Ball";

namespace {
  bool useless = (FactoryTable::registerSubclass ("Ball", "PhysicsObject"),
		  TheObjectDrawerFactory::registerObjectDrawer ("Ball"),
		  true);
}
