// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __RungaKutta_h__
#define __RungaKutta_h__

#ifndef __Float_h__
#include "Float.h"
#endif

#ifndef __Integrator_h__
#include "Integrator.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class Evaluator;

// From Numerical Analysis, Second Edition, by Burden, Faires, and
// Reynolds, 1978, page 205ff.
class RungaKutta: public Integrator {
  int m_startedSize;
  Float m_time;
  Float m_step;
  // Next ones are allocated and deleted by this class.
  // Beware -- my m_k1 * m_step is equal to their K1.
  Float *m_k1;
  Float *m_k2;
  Float *m_k3;
  Float *m_k4;
  Float *m_tmp;
  SP<Evaluator> m_f;
  bool isStarted ();
 public:
  RungaKutta ();
  void start (Float initialTime,
	      Float initialStep);
  void stop (Float &time, Float &step);
  void setEvaluator (Evaluator *f);
  Evaluator *getEvaluator ();
  Float observe ();
  ~RungaKutta ();
};

#endif
