// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Vec3i_h__
#define __Vec3i_h__

class Vec3i {
  int m_val [3];
 public:
  inline Vec3i () {};
  inline Vec3i (int x, int y, int z) {
    m_val [0] = x;
    m_val [1] = y;
    m_val [2] = z;
  }
  inline int & operator[] (int i) {
    return m_val[i];
  }
  inline const int & operator [] (int i) const {
    return m_val[i];
  }
  inline bool operator== (const Vec3i &v) const {
    return (m_val [0] == v [0]) &&
      (m_val [1] == v [1]) &&
      (m_val [2] == v [2]);
  }
  inline Vec3i operator- (const Vec3i &v) const {
    return Vec3i (m_val[0] - v[0], m_val[1] - v[1], m_val[2] - v[2]);
  }
  inline Vec3i operator+ (const Vec3i &v) const {
    return Vec3i (m_val[0] + v[0], m_val[1] + v[1], m_val[2] + v[2]);
  }
  inline Vec3i operator/ (int i) const {
    return Vec3i (m_val[0]/i, m_val[1]/i, m_val[2]/i);
  }
};

#endif
