// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "Vec3.h"

// Next one defines ostream.
#ifndef __iostream_h__
#include <iostream.h>
#define __iostream_h__
#endif

#ifndef __Float_h__
#include "Float.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

ostream & operator <<(ostream &o, const Vec3 &v) {
  return o<<"("<<v[0]<<", "<<v[1]<<", "<<v[2]<<")";
}

Vec3::operator String () const {
  return String ("(")+values[0]+", "+values[1]+", "+values[2]+")";
}

#ifndef __Vec3i_h__
#include "Vec3i.h"
#endif

Vec3::Vec3 (const Vec3i &v) {
  values [0] = v [0];
  values [1] = v [1];
  values [2] = v [2];
}

#ifdef TEST
int main () {
  Vec3 a (1, 2, 3);
  Vec3 b (4, 5, 6);
  Vec3 c = a.cross (b);
  const Float epsilon = 0.0001;
  assert (-epsilon < a * c && a * c < epsilon);
  assert (-epsilon < b * c && b * c < epsilon);
  Vec3 d = a.cross (a);
  assert (epsilon > d.length());
  assert ("Testing assert at the end" && 0);
}
#endif

