// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __XKeyboardMouse_h__
#define __XKeyboardMouse_h__

#ifndef __KeyboardMouse_h__
#include "KeyboardMouse.h"
#endif

// For XEvent.
#ifndef __X11_Xlib_h__
#include <X11/Xlib.h>
#define __X11_Xlib_h__
#endif

class XKeyboardMouse
  : public KeyboardMouse
{
  struct XKeyboardMouseData;
  XKeyboardMouseData *m_data;
public:
  // Next one causes the device to treat the given X event as input.  If we
  // know how to convert the X event into a KeyboardMouse event, we do so and
  // and then cause that event to be the current event and return true.
  // Otherwise we do nothing except return false.
  // 
  // Since KeyboardMouseEvent reports y increasing upwards, but X reports y
  // increasing downwards, we need to take the height of the screen as an
  // argument so we can turn the y cooridinate around.
  bool insertXEvent (const XEvent *xevent, int height);
  XKeyboardMouse ();
  ~XKeyboardMouse ();
  bool readEvent ();
  // Next one returns -1.
  int fdForSelect () const;
};

#endif
