// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __SpaceOrbEvent_h__
#define __SpaceOrbEvent_h__

#ifndef __Event_h__
#include "Event.h"
#endif

class String;
class Vec3;
class Quaternion;

class SpaceOrbEvent
  : public Event
{
  struct SpaceOrbEventData;
  SpaceOrbEventData *m_data;
public:
  SpaceOrbEvent ();
  ~SpaceOrbEvent ();
  // The buttons are A, B, C, D, E, F, m (motion), r (reset).
  Button minButton () const;
  Button maxButton () const;
  Button pointerMotionButton () const;
  bool isValidButton (Button ch) const;
  // The instantaneous translation specified by the SpaceOrb.  This is equal to
  // the translationalgain in the configuration, multiplied by the numbers that
  // the spaceorb-as-joystick gives us on the appropriate axes.
  // This is meant to be in the screen coordinate system, which (beware!) is
  // left-handed.
  Vec3 getTranslation () const;
  void setTranslation (const Vec3 &v);
  // Similarly, this is the instantaneous rotation specified by the SpaceOrb.
  // The rotationalgain in the configuration scales this.
  Quaternion getRotation () const;
  void setRotation (const Quaternion &q);
  // We could have mashed together the translation and the rotation to get a
  // matrix, but this way seems cleaner.  Multiplying rotations needs
  // occasional renormalization.  I can renormalize quaternions, but
  // renormalizing matrices requires converting to quaternion + translation,
  // normalizing the quaternion, and converting back.
  String unParseButton (Button b) const;
  String unParse () const;
  static const Button A;
  static const Button B;
  static const Button C;
  static const Button D;
  static const Button E;
  static const Button F;
  static const Button MOTION;
  static const Button RESET;
};
#endif
