// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __SpaceOrbConfiguration_h__
#include "SpaceOrbConfiguration.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __PositiveFloatSlotValue_h__
#include "PositiveFloatSlotValue.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __BoolSlotValue_h__
#include "BoolSlotValue.h"
#endif

#ifndef __SpaceOrbEvent_h__
#include "SpaceOrbEvent.h"
#endif

#ifndef __Event_h__
#include "Event.h"
#endif

#ifndef __DispatcherConfiguration_h__
#include "DispatcherConfiguration.h"
#endif

#ifndef __Macro_h__
#include "Macro.h"
#endif

#ifndef __TransformMacro_h__
#include "TransformMacro.h"
#endif

#ifndef __AnyOrbMove_h__
#include "AnyOrbMove.h"
#endif

namespace {
  String transGainName () {
    return "Translational Gain";
  }
  String rotGainName () {
    return "Rotational Gain";
  }
  String transStickName () {
    return "Translational Stiction";
  }
  String rotStickName () {
    return "Rotational Stiction";
  }
};

SpaceOrbConfiguration::SpaceOrbConfiguration ()
  : InputDeviceConfiguration ("SpaceOrbAction")
{
  ref ();
  initializeSlot (transGainName (), NEW (PositiveFloatSlotValue (0.5)));
  initializeSlot (rotGainName (), NEW (PositiveFloatSlotValue (0.2)));
  initializeSlot (transStickName (), NEW (PositiveFloatSlotValue (0.1)));
  initializeSlot (rotStickName (), NEW (PositiveFloatSlotValue (0.04)));
  SP<SpaceOrbEvent> soe = NEW (SpaceOrbEvent ());
  SP<DispatcherConfiguration> conf =
    NEW (DispatcherConfiguration (&*soe,
				  "SpaceOrbAction",
				  Dynavec <Event::Button> (SpaceOrbEvent::A,
							   SpaceOrbEvent::B)));
  conf->bindButton (SpaceOrbEvent::C, "GrowSelectionConnected",
		    SpaceOrbEvent::B);
  conf->bindButton (SpaceOrbEvent::D, "GrowSelectionNearby",
		    SpaceOrbEvent::B);
  conf->bindButton (SpaceOrbEvent::D, "CursorBallToCG");
  conf->bindButton (SpaceOrbEvent::F,
		    AnyOrbMove::mkOrbMove
		    (TransformMacro::mkMacro
		     (Dynavec <String>
		      ("TransformSelectionRHScreen",
		       "TransformCursorBallRHScreen"))));
  {
    SP<RecursiveSlotValue> rsv =
      AnyOrbMove::mkOrbMove ("TransformCursorBallRHScreen");
    conf->bindButton (SpaceOrbEvent::MOTION, rsv);
    conf->bindButton (SpaceOrbEvent::MOTION, rsv, SpaceOrbEvent::B);
  }
  conf->bindButton (SpaceOrbEvent::C,
		    AnyOrbMove::mkOrbMove ("TransformWorldMove"));
  SP<RecursiveSlotValue> dispatcherRSV =
    NEW (RecursiveSlotValue ("SpaceOrbAction",
			     "SpaceOrbDispatcher"));
  dispatcherRSV->setConfiguration (&*conf);
  setDispatcher (dispatcherRSV);
  deref ();
}

bool SpaceOrbConfiguration::hasTheSameTypeAs (const Configuration *c) const
{
  return 0 != dynamic_cast <const SpaceOrbConfiguration *> (c);
}

SP<Configuration> SpaceOrbConfiguration::copy () const {
  // Default copy constructor is sufficient.
  return NEW (SpaceOrbConfiguration (*this));
}

String SpaceOrbConfiguration::unParse () const {
  return "Space Orb Configuration";
}

void SpaceOrbConfiguration::setTranslationalGain (Float gain) {
  PositiveFloatSlotValue::setSlot (this, transGainName (), gain);
}

Float SpaceOrbConfiguration::getTranslationalGain () const {
  return PositiveFloatSlotValue::getSlot (this, transGainName ());
}

void SpaceOrbConfiguration::setRotationalGain (Float gain) {
  PositiveFloatSlotValue::setSlot (this, rotGainName (), gain);
}

Float SpaceOrbConfiguration::getRotationalGain () const {
  return PositiveFloatSlotValue::getSlot (this, rotGainName ());
}

void SpaceOrbConfiguration::setTranslationalStick (Float stick) {
  PositiveFloatSlotValue::setSlot (this, transStickName (), stick);
}

Float SpaceOrbConfiguration::getTranslationalStick () const {
  return PositiveFloatSlotValue::getSlot (this, transStickName ());
}

void SpaceOrbConfiguration::setRotationalStick (Float stick) {
  PositiveFloatSlotValue::setSlot (this, rotStickName (), stick);
}

Float SpaceOrbConfiguration::getRotationalStick () const {
  return PositiveFloatSlotValue::getSlot (this, rotStickName ());
}

