// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __InputDevicesFactory_h__
#include "InputDevicesFactory.h"
#endif

#ifndef __SimpleConfiguration_h__
#include "SimpleConfiguration.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __Configurable_h__
#include "Configurable.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __InputDevices_h__
#include "InputDevices.h"
#endif

#ifndef __InputDevice_h__
#include "InputDevice.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __LinuxJoystick_h__
#include "LinuxJoystick.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

namespace {
  class LJInputDevices
    : public InputDevices
  {
  public:
    void findDevices (Dynavec <SP <InputDevice> > &inputDevices)
    {
      inputDevices.extendTo (0);
      Dynavec <String> devNames = LinuxJoystick::joystickDeviceNames ();
      for (int i = 0; i < devNames.size (); i++) {
	SP<LinuxJoystick> lj =
	  LinuxJoystick::openJoystickDevice (devNames [i]);
	if (lj) {
	  inputDevices.push (&*lj);
	}
      }
    }
  };
  class LinuxJoystickFactory
    : public InputDevicesFactory
  {
  public:
    LinuxJoystickFactory ()
      : InputDevicesFactory ("LinuxJoystickFactory")
    {}
    Dynavec <SP <InputDevicesFactory> > inferiorDeviceFactories () const {
      return Dynavec <SP <InputDevicesFactory> > ();
    }
    SP<Configuration> defaultConfiguration () const {
      return NEW (SimpleConfiguration ());
    }
    SP<Configurable> makeIt (SP<Configuration> conf) const {
      (void) conf;
      return NEW (LJInputDevices ());
    }
  };
  static const bool useless =
  (FactoryTable::store ("InputDevicesFactory", NEW (LinuxJoystickFactory ())),
   true);
};
