// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __LinuxJoystick_h__
#define __LinuxJoystick_h__

#ifndef __InputDevice_h__
#include "InputDevice.h"
#endif

#ifndef __Joystick_h__
#include "Joystick.h"
#endif

class LinuxJoystick
  : public Joystick
{
  struct LinuxJoystickData;
  LinuxJoystickData *m_data;
  // pos is the position of this joystick device in the result from
  // joystickDeviceNames ().
  LinuxJoystick (int fd, int pos);
public:
  // This closes the file descriptor, marks the joystick device as available,
  // and deallocates memory.
  ~LinuxJoystick ();
  // The type of the joystick as reported by the operating system, such as
  // SpaceOrb 360 or Thrustmaster or whatever.  Use jstest from the joystick
  // package to find out the name of your joystick if you don't already know
  // it.
  String getName ();
  // All possible names of joystick devices.  The  return value is always the
  // same, including the order.
  static Dynavec <String> joystickDeviceNames ();
  // Next one silently returns the null pointer on a "No such device" error.
  // Other errors result in a message and a null pointer, or if the error is
  // sufficiently unexpected there will be a message and the program will
  // exit.
  // We will close the file descriptor when the LinuxJoystick is destructed.
  // If the device is already open for someone else, we'll silently return
  // null.  The operating system would allow us to open it again and get and
  // independent copy of the joystick events, but that isn't what we want, 
  // since we want each joystick device to be opened in only one way.
  static SP <LinuxJoystick> openJoystickDevice (const String &deviceName);
  bool readEvent ();
  int fdForSelect () const;
};
#endif
