// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __KeyboardMouseEvent_h__
#define __KeyboardMouseEvent_h__

#ifndef __Event_h__
#include "Event.h"
#endif

class KeyboardMouseEvent
  : public Event
{
  struct KeyboardMouseEventData;
  KeyboardMouseEventData* m_data;
public:
  KeyboardMouseEvent ();
  ~KeyboardMouseEvent ();
  Button pointerMotionButton () const;
  Button minButton () const;
  Button maxButton () const;
  int getX () const;
  void setX (int x);
  // Reports the y coordinate with y increasing upwards.
  int getY () const;
  void setY (int y);
  bool isValidButton (Button ch) const;
  // Convert an ASCII code to a button event, so we can smoothly do what the
  // user means when he tries to bind something to a character that's really a
  // button.  If the character is valid, this shouldn't be called, and a debug
  // build will abort.  If the character is invalid but it has no button,
  // BUTTON_LAST will be returned. 
  static Button toButtonEvent (char ch);
  // Next one doesn't make any use of "this", but we don't have it as a static
  // method so we can have it be virtual on Event; this allows the dispatcher
  // to be more portable.
  String unParseButton (Button be) const;
  String unParse () const;

  // Mouse motion events are button events with this
  // button; ignore the up/down flag.
  static const Button MOTION;
  static const Button LEFT_MOUSE;
  static const Button MIDDLE_MOUSE;
  static const Button RIGHT_MOUSE;
  // IntelliMouse is a trademark of Microsoft, by the way.
  // Hmm, if anybody has a more-than-three button mouse that isn't an
  // IntelliMouse, then the next two button names are simply wrong.  Let's
  // deal with that if and when it happens.  I have never met such a mouse.
  static const Button WHEEL_UP;
  static const Button WHEEL_DOWN;
  // The shift key.  We don't distinguish left from
  // right shift, since I don't think the user will be able to keep it
  // straight, and I'm not sure the hardware and window system reliably do
  // either.
  static const Button SHIFT;
  // Likewise, only one control button here, even if there are multiple
  // on the keyboard.
  static const Button CONTROL;
  // Alt is counted as meta, and we behave as though there's only one of
  // them.
  static const Button META;
  static const Button HOME;
  static const Button DELETE;
  static const Button END;
  static const Button BACKSPACE;
  static const Button PAGEUP;
  static const Button PAGEDOWN;
  // Return is also known as enter.
  static const Button RETURN;
  static const Button SPACE;
  static const Button TAB;
  static const Button ESCAPE;
  static const Button LEFTARROW;
  static const Button RIGHTARROW;
  static const Button DOWNARROW;
  static const Button UPARROW;
  // FIXME Add F1 throught F12 someday.
};
#endif
