// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __KeyboardMouse_h__
#define __KeyboardMouse_h__

#ifndef __InputDevice_h__
#include "InputDevice.h"
#endif

class KeyboardMouseEvent;

class KeyboardMouse
// Virtual inheritance here gets bogus compiler errors in gcc version 2.95.2.
// I have reported this bug.
//  : public virtual InputDevice
  : public InputDevice
{
  struct KeyboardMouseData;
  KeyboardMouseData *m_data;
protected:
  // Subclasses are responsible for doing the actual input, so we have to allow
  // subclasses to get to a non-const event, so they can set the fields 
  // of the event when the input happens.
  SP<KeyboardMouseEvent> getKeyboardMouseEvent ();
public:
  // The next one sets the default dispatcher to have a
  // nice bunch of bindings.
  KeyboardMouse ();
  ~KeyboardMouse ();
};


#endif
