// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __KeyboardMouse_h__
#include "KeyboardMouse.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __InputDeviceConfiguration_h__
#include "InputDeviceConfiguration.h"
#endif

#ifndef __DispatcherConfiguration_h__
#include "DispatcherConfiguration.h"
#endif

#ifndef __Event_h__
#include "Event.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __KeyboardMouseEvent_h__
#include "KeyboardMouseEvent.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __MacroConfiguration_h__
#include "MacroConfiguration.h"
#endif

#ifndef __TransformConfiguration_h__
#include "TransformConfiguration.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __Macro_h__
#include "Macro.h"
#endif

#ifndef __ConfigureAndRunConfiguration_h__
#include "ConfigureAndRunConfiguration.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __TypedRecursiveSlotValue_h__
#include "TypedRecursiveSlotValue.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __AnyMouseXYZMove_h__
#include "AnyMouseXYZMove.h"
#endif

#ifndef __AnyMouseTrackball_h__
#include "AnyMouseTrackball.h"
#endif

#ifndef __EdgeHexConfiguration_h__
#include "EdgeHexConfiguration.h"
#endif

#ifndef __ChangeAtomTypeConfiguration_h__
#include "ChangeAtomTypeConfiguration.h"
#endif

#ifndef __CreateAtomConfiguration_h__
#include "CreateAtomConfiguration.h"
#endif

namespace {
  // Filled in in mkConf.
  KeyboardMouseEvent::Button maxButton = 0;
  static void bindEdgeHex (DispatcherConfiguration *conf, char key, int sides,
			   RecursiveSlotValue *atomFactory,
			   const int oldFaceSize,
			   const KeyboardMouseEvent::Button shift = maxButton)
  {
    assert (maxButton);
    SP<RecursiveSlotValue> rsv =
      NEW (RecursiveSlotValue ("KeyboardMouseAction", "EdgeHex"));
    SP<EdgeHexConfiguration> eConf =
      dynamic_cast <EdgeHexConfiguration *> (&*rsv->getConfiguration ());
    assert (eConf);
    eConf->setAtomFactory (atomFactory);
    eConf->setNewFaceSize (sides);
    eConf->setOldFaceSize (oldFaceSize);
    if (shift == maxButton) {
      conf->bindButton (key, rsv);
    } else {
      conf->bindButton (key, rsv, shift);
    }
  }
  
  class KeyboardInputDeviceConfiguration
    : public InputDeviceConfiguration
  {
  public:
    KeyboardInputDeviceConfiguration ()
      : InputDeviceConfiguration ("KeyboardMouseAction")
    {}
    String unParse () const {
      return "Keyboard and Mouse";
    }
    SP<Configuration> copy () const {
      return NEW (KeyboardInputDeviceConfiguration (*this));
    }
    bool hasTheSameTypeAs (const Configuration *c) const
    {
      return 0 != dynamic_cast <const InputDeviceConfiguration *> (c);
    }
  };
  SP<InputDeviceConfiguration> mkConf () {
    SP<KeyboardMouseEvent> kme = NEW (KeyboardMouseEvent ());
    maxButton = kme->maxButton ();
    assert (maxButton);
    SP<DispatcherConfiguration> conf =
      NEW (DispatcherConfiguration
	   (&*kme,
	    "KeyboardMouseAction",
	    Dynavec <Event::Button> (KeyboardMouseEvent::SHIFT,
				     KeyboardMouseEvent::META,
				     KeyboardMouseEvent::CONTROL)));
    conf->bindButton ('b', "InferBonds");
    conf->bindButton ('n', "NewScene");
    conf->bindButton ('c', "EditConfiguration");
    conf->bindButton ('s', "StartStopTime");
    conf->bindButton ('t', "ReportTimes");
    conf->bindButton ('v', "ViewScene");
    conf->bindButton ('w', "NewTopLevel");
    conf->bindButton ('l', "MakeLink");
    conf->bindButton ('l', "DeleteLink", KeyboardMouseEvent::SHIFT);
    conf->bindButton (';', "IdentifyAction");
    conf->bindButton (';', "IdentifyNear", KeyboardMouseEvent::SHIFT);
    {
      SP<RecursiveSlotValue> rsv =
	NEW (RecursiveSlotValue ("KeyboardMouseAction", "ConfigureAndRun"));
      SP<ConfigureAndRunConfiguration> carc =
	dynamic_cast <ConfigureAndRunConfiguration *>
	(&*rsv->getConfiguration ());
      carc->setRSV (NEW2 (TypedRecursiveSlotValue<ActionConfiguration, Action>
			  ("Action", "AnyCommand")));
      conf->bindButton (';', rsv, KeyboardMouseEvent::META);
    }
    conf->bindButton (KeyboardMouseEvent::DELETE, "DeleteObject");
    conf->bindButton (KeyboardMouseEvent::MIDDLE_MOUSE, "TranslateOrScale");
    conf->bindButton (KeyboardMouseEvent::MIDDLE_MOUSE, "TranslateOrScale",
		      KeyboardMouseEvent::SHIFT);
    conf->bindButton (KeyboardMouseEvent::LEFT_MOUSE,
		      Macro::mkMacro ("KeyboardMouseAction",
				      Dynavec <String>
				      ("DeselectAll", "SelectCube")));
    conf->bindButton (KeyboardMouseEvent::LEFT_MOUSE, "SelectCube",
		      KeyboardMouseEvent::SHIFT);
    conf->bindButton
      (KeyboardMouseEvent::RIGHT_MOUSE,
       AnyMouseXYZMove::mkMouseXYZMove ("TransformSelectionRHScreen"));
    conf->bindButton
      (KeyboardMouseEvent::RIGHT_MOUSE,
       AnyMouseXYZMove::mkMouseXYZMove ("TransformSelectionRHScreen"),
       KeyboardMouseEvent::SHIFT);
    conf->bindButton
      (KeyboardMouseEvent::RIGHT_MOUSE,
       AnyMouseTrackball::mkMouseTrackball ("TransformSelectionRHScreen"),
       KeyboardMouseEvent::CONTROL);
    conf->bindButton
      (KeyboardMouseEvent::MIDDLE_MOUSE,
       AnyMouseTrackball::mkMouseTrackball ("TransformWorldMove"),
       KeyboardMouseEvent::CONTROL);
    conf->bindButton ('x', "DeleteSelection", KeyboardMouseEvent::CONTROL);
    { // Bind 'c' to a variant of the copy-selection command that translates
      // the copy slightly, so you can see it blink.
      SP<RecursiveSlotValue> bump =
	NEW (RecursiveSlotValue ("Action",
				 "TransformSelectionRHScreen"));
      {
	SP<TransformConfiguration> bumpConf =
	  dynamic_cast <TransformConfiguration *>
	  (&*bump->getConfiguration ());
	assert (bumpConf);
	// 10 pixels in the positive x direction.
	bumpConf->setTranslation (Vec3 (10, 0, 0));
      }
      conf->bindButton
	('c',
	 Macro::mkMacro ("KeyboardMouseAction",
			 Dynavec <SP<RecursiveSlotValue> >
			 (NEW (RecursiveSlotValue ("Action",
						   "CopySelection")),
			  bump
			  // Skip the next one, since I don't like using the
			  // SpaceOrb any more. 
			  //,
			  //// The next thing to do after copying is moving,
			  //// so move the cursorball to the middle of the
			  //// selection.  Otherwise a twist on the orb tends
			  //// to make the selection zoom around too much.
			  //NEW (RecursiveSlotValue ("Action",
			  //"CursorBallToCG"))
			  )),
	 KeyboardMouseEvent::CONTROL);
    }
    {
      SP<RecursiveSlotValue> rsv =
	NEW (RecursiveSlotValue ("KeyboardMouseAction", "ConfigureAndRun"));
      SP<ConfigureAndRunConfiguration> carc =
	dynamic_cast <ConfigureAndRunConfiguration *>
	(&*rsv->getConfiguration ());
      carc->setRSV (NEW2 (TypedRecursiveSlotValue<ActionConfiguration, Action>
			  ("Action", "AnyFileSceneWriter")));
      conf->bindButton ('s', rsv, KeyboardMouseEvent::CONTROL);
    }
    // This will be shared among many configurations, so they'll all create the
    // same type of atom. 
    SP<RecursiveSlotValue> theAtomRSV;
    {
      // Comma creates an atom all by itself.  Shift-comma reconfigures the
      // atom creator and then creates an atom.  It's the same atom creator. 
      SP<RecursiveSlotValue> createAtom =
	NEW (RecursiveSlotValue ("KeyboardMouseAction", "CreateAtom"));
      SP<CreateAtomConfiguration> cac =
	dynamic_cast <CreateAtomConfiguration *>
	(&*createAtom->getConfiguration ());
      assert (cac);
      theAtomRSV = cac->getAtomSlot ();
      conf->bindButton (',', createAtom);
      SP<RecursiveSlotValue> rsv =
	NEW (RecursiveSlotValue ("KeyboardMouseAction", "ConfigureAndRun"));
      SP<ConfigureAndRunConfiguration> carc =
	NEW (ConfigureAndRunConfiguration ("KeyboardMouseAction"));
      assert (carc);
      rsv->setConfiguration (&*carc);
      carc->setRSV (createAtom);
      conf->bindButton (',', rsv, KeyboardMouseEvent::SHIFT);
    }
    {
      SP<RecursiveSlotValue> rsv =
	NEW (RecursiveSlotValue ("KeyboardMouseAction", "ConfigureAndRun"));
      SP<ConfigureAndRunConfiguration> carc =
	dynamic_cast <ConfigureAndRunConfiguration *>
	(&*rsv->getConfiguration ());
      carc->setRSV (NEW2 (TypedRecursiveSlotValue<ActionConfiguration, Action>
			  ("Action", "ChangeAtomType")));
      SP<ChangeAtomTypeConfiguration> catc =
	dynamic_cast <ChangeAtomTypeConfiguration *>
	(&*carc->getRSV()->getConfiguration ());
      catc->setAtomSlot (theAtomRSV);
      conf->bindButton ('.', rsv);
    }
    bindEdgeHex (conf, 'e', 6, theAtomRSV, 8, KeyboardMouseEvent::SHIFT);
    // Use 7 on next line so we can close a dodecahedron.
    bindEdgeHex (conf, '5', 5, theAtomRSV, 7);
    bindEdgeHex (conf, '6', 6, theAtomRSV, 8);
    bindEdgeHex (conf, '7', 7, theAtomRSV, 8);
    conf->bindButton ('/', "InspectAtom");
    {
      SP<RecursiveSlotValue> rsv =
	NEW (RecursiveSlotValue ("KeyboardMouseAction", "ConfigureAndRun"));
      SP<ConfigureAndRunConfiguration> carc =
	dynamic_cast <ConfigureAndRunConfiguration *>
	(&*rsv->getConfiguration ());
      carc->setRSV (NEW2 (TypedRecursiveSlotValue<ActionConfiguration, Action>
			  ("Action", "AnyFileSceneLoader")));
      conf->bindButton ('r', rsv, KeyboardMouseEvent::CONTROL);
    }
    {
      SP<RecursiveSlotValue> rsv =
	NEW (RecursiveSlotValue ("KeyboardMouseAction", "ConfigureAndRun"));
      SP<ConfigureAndRunConfiguration> carc =
	dynamic_cast <ConfigureAndRunConfiguration *>
	(&*rsv->getConfiguration ());
      carc->setRSV (NEW2 (TypedRecursiveSlotValue<ActionConfiguration, Action>
			  ("Action", "PlayBrennerMovie")));
      conf->bindButton ('m', rsv, KeyboardMouseEvent::CONTROL);
    }
    conf->bindButton ('i', "SelectionInvisible");
    // The macro commented out below is replaced by ToggleConnectedSelection.
    //conf->bindButton (KeyboardMouseEvent::LEFT_MOUSE,
    //Macro::mkMacro
    //("KeyboardMouseAction",
    //Dynavec <String> ("DeselectAll",
    //// Can't use SelectCube here yet,
    //// because it grabs the mouse and
    //// grabbing actions can't go into
    //// macros yet.
    //"SelectUnderMouse",
    //"GrowSelectionConnected")),
    //KeyboardMouseEvent::CONTROL);
    conf->bindButton (KeyboardMouseEvent::LEFT_MOUSE,
		      "ToggleConnectedSelection",
		      KeyboardMouseEvent::CONTROL);
    SP<RecursiveSlotValue> dispatcherRSV =
      NEW (RecursiveSlotValue ("KeyboardMouseAction",
			       "KeyboardMouseDispatcher"));
    dispatcherRSV->setConfiguration (&*conf);
    SP<InputDeviceConfiguration> result =
      NEW (KeyboardInputDeviceConfiguration ());
    result->setDispatcher (dispatcherRSV);
    return result;
  }
};

struct KeyboardMouse::KeyboardMouseData {
  // nothing yet.
};

KeyboardMouse::KeyboardMouse ()
  : InputDevice (mkConf (), NEW (KeyboardMouseEvent ())),
    m_data (NEW (KeyboardMouseData ()))
{}
  
KeyboardMouse::~KeyboardMouse () {
  assert (m_data);
  delete m_data;
  m_data = 0;
}

SP<KeyboardMouseEvent> KeyboardMouse::getKeyboardMouseEvent () {
  SP<KeyboardMouseEvent> result =
    dynamic_cast <KeyboardMouseEvent *> (&*getVariableEvent ());
  assert (result);
  return result;
}

namespace {
  bool useless =
  (FactoryTable::registerSubclass ("Action", "KeyboardMouseAction"),
   true);
};
