// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Joystick_h__
#include "Joystick.h"
#endif

#ifndef __InputDeviceConfiguration_h__
#include "InputDeviceConfiguration.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __JoystickEvent_h__
#include "JoystickEvent.h"
#endif

#ifndef __Event_h__
#include "Event.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

namespace {
  // There isn't anything to configure with a Linux joystick, AFAIK.
  class JoystickConfiguration
    : public InputDeviceConfiguration
  {
  public:
    JoystickConfiguration ()
      : InputDeviceConfiguration ("Action")
    {}
    JoystickConfiguration (const JoystickConfiguration &ljc)
      : InputDeviceConfiguration (ljc)
    {}
    bool hasTheSameTypeAs (const Configuration *c) const {
      return 0 != dynamic_cast <const JoystickConfiguration *> (c);
    }
    SP<Configuration> copy () const {
      return NEW (JoystickConfiguration (*this));
    }
    String unParse () const {
      return "Joystick";
    }
  };
  SP<InputDeviceConfiguration> mkConf (int axes, int buttons) {
    SP<JoystickEvent> je = NEW (JoystickEvent (axes, buttons));
    SP<InputDeviceConfiguration> result = NEW (JoystickConfiguration ());
#if 0
    SP<DispatcherConfiguration> conf =
      NEW (DispatcherConfiguration (&*je, Dynavec <Event::Button> ()));
    conf->bindButton (je->pointerMotionButton (), "JoystickMotion");
    SP<RecursiveSlotValue> dispatcherRSV =
      NEW (RecursiveSlotValue ("Action", "Dispatcher"));
    dispatcherRSV->setConfiguration (&*conf);
    result->setDispatcher (dispatcherRSV);
#else
    // Instead of using a dispatcher, I just want to print all of the events.
    result->setDispatcher
      (NEW (RecursiveSlotValue ("Action", "Motion")));
#endif
    return result;
  }
};

Joystick::Joystick (int axes, int buttons)
  : InputDevice (mkConf (axes, buttons), NEW (JoystickEvent (axes, buttons)))
{}
  
