// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __InputDevicesFactory_h__
#define __InputDevicesFactory_h__

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class String;
class InputDevice;

class InputDevicesFactory
  : public Factory
{
protected:
  InputDevicesFactory (const String &name);
public:
  // Running the factory gives you an InputDevices, which is a list of all of
  // the input devices that the InputDevicesFactory found and was able to
  // open. 
  // Lists all of the device types that are inferior to the present one.  Try
  // the best device types first.
  virtual Dynavec <SP <InputDevicesFactory> > inferiorDeviceFactories () const
    = 0;
  // Find all of the registered instances of InputDevicesFactory that start
  // with any of the the given prefixes, determine a good order to run them,
  // run them, concatenate the results and return.
  static void openDevices (const Dynavec <String> &prefixes,
			   Dynavec <SP <InputDevice> > &inputDevices);
};

#endif
