// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __InputDevicesFactory_h__
#include "InputDevicesFactory.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __InputDevices_h__
#include "InputDevices.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __stdlib_h__
#include <stdlib.h>
#define __stdlib_h__
#endif

#ifndef __iostream_h__
#include <iostream.h>
#define __iostream_h__
#endif

#ifndef __ConstantRecursiveSlotValue_h__
#include "ConstantRecursiveSlotValue.h"
#endif

#ifndef __Configurable_h__
#include "Configurable.h"
#endif

#ifndef __InputDevice_h__
#include "InputDevice.h"
#endif

InputDevicesFactory::InputDevicesFactory (const String &name)
  : Factory (name)
{}

void InputDevicesFactory::openDevices
(const Dynavec <String> &prefixes,
 Dynavec <SP <InputDevice> > &inputDevices)
{
  inputDevices.extendTo (0);
  Dynavec <SP<Factory> > factories =
    FactoryTable::load ("InputDevicesFactory");
  Dynavec <SP<InputDevicesFactory> > idfs;
  for (int i = 0; i < factories.size(); i++) {
    SP<InputDevicesFactory> idf =
      dynamic_cast <InputDevicesFactory *> (&*factories[i]);
    assert (idf);
    for (int j = 0; j < prefixes.size(); j++) {
      if (idf->getName().substring (0, prefixes[j].size()) == prefixes[j]) {
	idfs.push (idf);
	break;
      }
    }
  }
  SP<InputDevice> result;
  while (idfs.size ()) {
    bool progress = false;
    for (int i = 0; i < idfs.size(); ) {
      SP<InputDevicesFactory> idf = idfs[i];
      bool goodEnough = true;
      for (int j = 0; j < idfs.size(); j++) {
	Dynavec <SP <InputDevicesFactory> > worse =
	  idfs[j]->inferiorDeviceFactories ();
	for (int k = 0; k < worse.size(); k++) {
	  if (worse [k] == idf) {
	    goodEnough = false;
	  }
	}
      }
      if (goodEnough) {
	progress = true;
	// Take it out of the list.  Note that we don't increment i in this
	// case.
	idfs [i] = idfs [idfs.size() - 1];
	idfs.pop ();
	// Run it.
	// FIXME Give the user a chance to configure InputDevices
	// We aren't giving the user any chance to have anything but the
	// default configurations here, which is as good as no configuration at
	// all.  But all this happens before we start doing serious I/O with
	// the user anyway, so maybe it doesn't matter that we aren't
	// giving the user a chance to interact here.
	// If we had a way to save the configuration from one run to the next,
	// then we could restore the configuration for the input device.
	SP<Configurable> c = idf->makeIt ();
	SP<InputDevices> ids = dynamic_cast <InputDevices *> (&*c);
	assert (ids);
	Dynavec <SP <InputDevice> > did;
	ids->findDevices(did);
	for (int j = 0; j < did.size(); j++) {
	  inputDevices.push (did [j]);
	}
      } else {
	i++;
      }
    }
    if (!progress) {
      cerr << "The following InputDevicesFactory's all want to run before "
	   << endl
	   << "each other, so there is no good order to run them:" << endl;
      for (int i = 0; i < idfs.size(); i++) {
	cerr << idfs[i]->getName() << endl;
      }
      abort ();
    }
  }
}
