// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __InputDevices_h__
#define __InputDevices_h__

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __ConstantRecursiveSlotValue_h__
#include "ConstantRecursiveSlotValue.h"
#endif

#ifndef __Configurable_h__
#include "Configurable.h"
#endif

class InputDevice;
class Configuration;

// An InputDevices is what you get when you run an InputDevicesFactory.
// It's a list of InputDevice's, along with a list of the configurations (of
// the same length) that were used when generating the corresponding
// InputDevice's.  The idea is that an InputDevicesFactory can create a
// connection between the configurations and the InputDevice's to allow users
// to reconfigure their input devices as they are using them.
class InputDevices
  : public Configurable
{
public:
  // Returns a bunch of inputDevices
  virtual void findDevices (Dynavec <SP <InputDevice> > &inputDevices) = 0;
};

#endif
