// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __InputDeviceType_h__
#define __InputDeviceType_h__

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class InputDeviceType {

  // An interface that represents a type of input device that may be hooked
  // into the system.
  //
  // If your Fungimol instance functions under two window systems (say, X and
  // Windows), and you know about two types of input devices (say, a
  // mouse/keyboard and a Space Orb), then you'll have four of these, with
  // names like XMouseKeyboard, XSpaceOrb, WinMouseKeyboard, and WinSpaceOrb.
  // The TopLevel determines the prefix "X" or "Win", then it enumerates the
  // InputDeviceTypes's with that prefix and tries to use all of them.  It may
  // conspire with some input devices that can't do their jobs by themselves,
  // such as the mouse/keyboard input device, or it can leave an input device
  // on its own to get its input, such as a joystick.
  //
  // If you have two space orbs, then you will still have only one of these
  // that deals with Space Orbs.  When you invoke findDevices for it, it will
  // return a vector with the two InputDevice's for the SpaceOrb's.
public:
  virtual Dynavec<SP <InputDevice> > findDevices () = 0;
};

#endif
