// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __InputDeviceConfiguration_h__
#include "InputDeviceConfiguration.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

namespace {
  String dispatchName () {
    return "Key and Button Dispatch Table";
  }
};

InputDeviceConfiguration::InputDeviceConfiguration (const String &protocol) {
  initializeSlot (dispatchName (),
		  NEW (RecursiveSlotValue (protocol, "DoNothing")));
}

InputDeviceConfiguration::~InputDeviceConfiguration ()
{}

SP<const RecursiveSlotValue> InputDeviceConfiguration::getDispatcher () const
{
  return RecursiveSlotValue::getSlotValue (this, dispatchName());
}

SP<RecursiveSlotValue> InputDeviceConfiguration::getDispatcher ()
{
  return RecursiveSlotValue::getSlotValue (this, dispatchName());
}

void InputDeviceConfiguration::setDispatcher (SP<RecursiveSlotValue> c)
{
  RecursiveSlotValue::setSlotValue (this, dispatchName (), c);
}

// We want to ensure that all InputDeviceConfigurations have a non-default
// unParse method so that the TopLevelConfiguration can print them when the
// user is editing the configurations.  Otherwise, we would try to derive
// information to print from the factory, and there is no useful factory stored
// there.
String InputDeviceConfiguration::unParse () const {
  return "Input Device Configuration that needs a custom unParse method";
}

SP<Configuration> InputDeviceConfiguration::copy () const {
  return NEW (InputDeviceConfiguration (*this));
}

bool InputDeviceConfiguration::hasTheSameTypeAs (const Configuration *c) const
{
  return 0 != dynamic_cast <const InputDeviceConfiguration *> (c);
}
