// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __DispatcherConfiguration_h__
#define __DispatcherConfiguration_h__

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __Event_h__
#include "Event.h"
#endif

class Action;
class RecursiveSlotValue;
class ostream;
class Configuration;

// Do different actions depending on which event happened most recently.
// We will dispatch the event in the toplevel we are given.
class DispatcherConfiguration
  : public ActionConfiguration
{
  struct DispatcherConfigurationData;
  DispatcherConfigurationData *m_data;
public:
  typedef Event::Button Button;
  // FIXME Let the user reconfigure the list of shift buttons.
  DispatcherConfiguration (SP<const Event> event,
			   // The protocol that actions are selected from.
			   // Typical values are "KeyboardMouseAction" or
			   // "SpaceOrbAction".
			   const String &protocolName,
			   const Dynavec <Button> &shiftButtons);
  ~DispatcherConfiguration ();
  DispatcherConfiguration (const DispatcherConfiguration &dc);
  SP<Configuration> copy () const;
  bool hasTheSameTypeAs (const Configuration *c) const;
  // f should generate an action.  Record the binding so we can return
  // it later when getBinding is called.  We take a RecursiveSlotValue
  // instead of a Factory so that the client can pass in a non-default
  // configuration if he wants to, and that configuration can be edited by the
  // user.
  // Take a RecursiveSlotValue * instead of a SP<RecursiveSlotValue>
  // because if we take the smart pointer, then calling it with a
  // RecursiveSlotValue * is ambiguous, since that may be converted
  // either into the smart pointer or into a bool and then into a String.
  // You must specify a shift key that the button is bound to, but if you
  // specify e->maxButton () (where e is the event that was passed to
  // DispatcherConfiguration at the time it was created), then you're binding
  // the key with no shift.  The shift keys permitts are the ones passed in the
  // shiftButtons argument when this DispatcherConfiguration was created.
  // Right now we don't allow binding things when there are two or more shift
  // keys pressed, like control-meta x.
  void bindButton (Button key, RecursiveSlotValue *f, Button shift);
  // Next one defaults the shift to e->maxButton ().
  void bindButton (Button key, RecursiveSlotValue *f);
  // For the next one, they get the default configuration, and we
  // assume that the factoryName is registered as an Action.
  void bindButton (Button key, const String &factoryName, Button shift);
  // Next one defaults shift to e->maxButton() again.
  void bindButton (Button key, const String &factoryName);
  SP<RecursiveSlotValue> getBinding (SP<const Event> event);
  // Return a list of the shift buttons.
  const Dynavec <Button> &getShiftButtons () const;
  // Print the table.  Last character written is a newline.
  friend ostream &operator<< (ostream &o,
			      const DispatcherConfiguration &dc);
};

#endif
