// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __HashTableTypeless_h__
#define __HashTableTypeless_h__

#ifndef __Refcount_h__
#include "Refcount.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class Hashable;

class HashTableTypeless : public Refcount {
 protected:
  // Only subclasses can make this class.
  HashTableTypeless ();
  friend class HashTableIteratorTypeless;
  virtual void iteratorFirst (HashTableIteratorTypeless &i) const = 0;
  virtual void iteratorNext (HashTableIteratorTypeless &i) const = 0;
  virtual bool iteratorIsDone (const HashTableIteratorTypeless &i) const = 0;
  virtual const Hashable *iteratorCurrentItem
    (const HashTableIteratorTypeless &i) const
    = 0;
 public:
  virtual void store (const Hashable &d, SP<Refcount> r) = 0;
  virtual Refcount *load (const Hashable &d) = 0;
  virtual const Refcount *load (const Hashable &d) const = 0;
  virtual HashTableIteratorTypeless iterator () = 0;
  virtual ~HashTableTypeless ();
};

#endif
