// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __HashTableImpl_h__
#define __HashTableImpl_h__

#ifndef __Hashable_h__
#include "Hashable.h"
#endif

#ifndef __HashTableTypeless_h__
#include "HashTableTypeless.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class HashTableEnt;
class Refcount;

class HashTableImpl : public HashTableTypeless {
  HashTableEnt *vec;
  int sizeShift;
  int currentUsage;
  /* If an addition would caus currentUsage to become bigger than */
  /* maxUsage, grow the table before inserting. */ 
  /* maxUsage is always 3/4 * (1 << sizeShift).  We have the field so */
  /* we don't have to recompute it on every insert. */
  int maxUsage; 
  /* We grow the table when it is 3/4 full, and we always need to have */
  /* an empty slot, so INITIAL_SIZE_SHIFT had better be at least 2. */
  /* Make it bigger if you know the table will end up big (and you */
  /* aren't debugging). */
  static const int INITIAL_SIZE_SHIFT = 4;
  // set maxUsage to a good value.
  void figureMaxUsage ();
  int table_slot (const Hashable &key, Hashable::HASH thisHash) const;
  void growTable ();
  // An iterator is normalized if we know its index points at an
  // existing element, or its index points past the end.
  void iteratorNormalize (HashTableIteratorTypeless &i) const;
  // The iterator is normalized when iteratorFirst returns.
  void iteratorFirst (HashTableIteratorTypeless &i) const;
  // The iterator is normalized when iteratorNext returns.
  void iteratorNext (HashTableIteratorTypeless &i) const;
  // iteratorIsDone assumes the iterator is normalized.
  bool iteratorIsDone (const HashTableIteratorTypeless &i) const;
  // iteratorCurrentItem assumes the iterator is normalized.
  const Hashable *iteratorCurrentItem (const HashTableIteratorTypeless &i) const;
 public:
#ifndef NDEBUG
  static int growths;
  static int collisions;
  static int probes;
#endif
  HashTableImpl ();
  ~HashTableImpl ();
  void store (const Hashable &d, SP<Refcount> r);
  Refcount *load (const Hashable &d);
  const Refcount *load (const Hashable &d) const;
  HashTableIteratorTypeless iterator ();
};

#endif
