// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Viewport_h__
#define __Viewport_h__
// Return value from GL::getViewport.
class Viewport {
  int nums [4];
 public:
  Viewport (int x, int y, int width, int height)
  {
    nums [0] = x;
    nums [1] = y;
    nums [2] = width;
    nums [3] = height;
  }
  Viewport ()
    {
#ifndef NDEBUG
      // Deterministic bugs are good.
      nums [0] = -10000;
      nums [1] = 1000000;
      nums [2] = 93209;
      nums [3] = 4324234;
#endif
    }
  inline int x () const {return nums [0];}
  inline int y () const {return nums [1];}
  inline int width () const {return nums [2];}
  inline int height () const {return nums [3];}
  // Convert the Viewport to a pointer for passing it to OpenGL routines.
  inline const int *pointer () const {
    return nums;
  }
  inline int *pointer () {
    return nums;
  }
  inline bool operator== (const Viewport &other) const {
    return x() == other.x() && y() == other.y() && width() == other.width()
      && height() == other.height();
  }
  inline bool operator!= (const Viewport &other) const {
    return ! (*this == other);
  }
};

class ostream;
ostream & operator<< (ostream &o, const Viewport &vp);
#endif
