// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __IMWheel_h__
#define __IMWheel_h__

// Microsoft Intellimouse wheel motions.  You get one mouse event per
// upward or downward click of the wheel, and the button goes both
// down and up for each click of the wheel.  The following numbers
// will be given to the "mouse" function as the first argument "button".

// These assume that you modified /etc/X11/XF86Config according to the
// instructions in the "imwheel" manual entry.  The important lines
// in the file are:
// Section "Pointer"
//    Protocol    "IMPS/2"
//    Device      "/dev/mouse"
//    ZAxisMapping    4 5
// You don't have to actually run imwheel for this to work, though.
// When using this with Glut, the numbers 3 and 4 are good.
// When using this with GLX, add 1 to the constants here and match
// them against the X event.
// There's an off-by-one somewhere between XF86Config and us, so we
// have 3 and 4 here even though 4 and 5 were specified in the file.
struct IMWheel {
  static const int WheelUp = 3;
  static const int WheelDown = 4;
};

#endif
