// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Color_h__
#define __Color_h__

#ifndef __myassert_h__
#include "myassert.h"
#endif

// A Color for OpenGL.
#ifndef __Float_h__
#include "Float.h"
#endif

class Color {
  float values [4];
 public:
  // red, green, blue, alpha.
  Color (float f0, float f1, float f2, float f3) {
    values [0] = f0;
    values [1] = f1;
    values [2] = f2;
    values [3] = f3;
  }
  Color () {};
  inline float *pointer () {
    return values;
  }
  inline const float *pointer () const {
    return values;
  }
  inline float & Color::operator[] (int index) {
    assert (0 <= index && index < 4);
    return values [index];
  }
  
  inline const float & Color::operator[] (int index) const {
    assert (0 <= index && index < 4);
    return values [index];
  }
  
private:
  float clampOne (float c) {
    if (c < 0) {
      return 0;
    } else if (c > 1) {
      return 1;
    } else {
      return c;
    }
  }
public:
  inline Color clamp () {
    return Color (clampOne (values[0]), clampOne (values[1]),
		  clampOne (values [2]), clampOne (values [3]));
  }
};

inline Color operator* (const Color &m, Float f) {
  return Color (m[0]*f, m[1]*f, m[2]*f, m[3]*f);
}

inline Color operator* (Float f, const Color &m) {
  return m * f;
}

inline Color operator/ (const Color &m, Float f) {
  return m * (1 / f);
}

inline bool operator== (const Color &c1, const Color &c2) {
  return c1[0] == c2[0] && c1[1] == c2[1] && c1[2] == c2[2];
}

inline bool operator!= (const Color &c1, const Color &c2) {
  return ! (c1 == c2);
}
#endif
