// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __BoundingSphere_h__
#define __BoundingSphere_h__

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __Float_h__
#include "Float.h"
#endif

// This includes all points *less than* the given radius from the
// given center.  Since it's less than, we can easily convert to a
// BoundingBox.
class BoundingBox;
class BoundingSphere {
  // Special case: negative m_radius means that we don't know the
  // extent of the object, so we conservatively assume it to be
  // infinite.  In this case the center should not be used.
  Float m_radius;
  Vec3 m_center;
 public:
  BoundingSphere (Float a_radius, const Vec3 &a_center);
  // Default constructor gives negative radius.
  BoundingSphere ();
  // Next one is quick and dirty.  It sometimes gives you a larger
  // sphere than strictly necessary, but it can do it without taking
  // any square roots.
  BoundingSphere (const BoundingBox &box);
  inline Float radius () const {
    return m_radius;
  }
  inline Vec3 center () const {
    return m_center;
  }
  void merge (const BoundingSphere &toAdd);
  // Whether the present bounding sphere overlaps the given one.
  bool overlaps (const BoundingSphere &s) const;
  inline bool isBounded () const { return m_radius >= 0; };
  bool contains (const Vec3 &v) const;
};

#endif
