// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "BoundingBoxInt.h"

#ifndef __BoundingBox_h__
#include "BoundingBox.h"
#endif

#ifndef __FloatUtil_h__
#include "FloatUtil.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __Vec3i_h__
#include "Vec3i.h"
#endif

// Put this out-of-line so that BoundingBoxInt.h doesn't have to include BoundingBox.h.
BoundingBoxInt::BoundingBoxInt (const BoundingBox &b, Float unitSize) {
  assert (unitSize > 0.0);
  Vec3 least = b.least () / unitSize;
  Vec3 most = b.most () / unitSize;
  m_min = Vec3i (FloatUtil::floor (least [0]),
		 FloatUtil::floor (least [1]),
		 FloatUtil::floor (least [2]));
  // Case 1: most [0]/unitSize is an integer, say 3.  Then b includes
  // points < 3 * unitSize. So we want 3 to be our maximum coordinate.
  // ceiling is appropriate here.
  // Case 2: most [0]/unitSize is not an integer, say 3.5.  Then b includes
  // points < 3.5 * unitSize.  Best we can do for m_max is 4.  ceiling
  // is appropriate here too.
  m_max = Vec3i (FloatUtil::ceiling (most [0]),
		 FloatUtil::ceiling (most [1]),
		 FloatUtil::ceiling (most [2]));
}

// Put this out-of-line so that BoundingBoxInt.h doesn't have to include Vec3i.h.
BoundingBoxInt::BoundingBoxInt (const Vec3i &v, int size) {
  assert (size >= 0);
  m_min = v;
  m_max = Vec3i (v [0] + size, v [1] + size, v [2] + size);
}



