// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __XYZCursorBallConfiguration_h__
#include "XYZCursorBallConfiguration.h"
#endif

#ifndef __Quaternion_h__
#include "Quaternion.h"
#endif

#ifndef __CursorBallConfiguration_h__
#include "CursorBallConfiguration.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __QuaternionSlotValue_h__
#include "QuaternionSlotValue.h"
#endif

#ifndef __ConstantRecursiveSlotValue_h__
#include "ConstantRecursiveSlotValue.h"
#endif

namespace {
  String markerName (char axisName) {
    assert ('X' <= axisName && 'Z' >= axisName);
    return String (axisName) + " Marker";
  }
};

XYZCursorBallConfiguration::XYZCursorBallConfiguration () {
  ref ();
  for (char c = 'X'; c <= 'Z'; c++) {
    SP<ConstantRecursiveSlotValue> crsv =
      NEW (ConstantRecursiveSlotValue ("CursorBall", "CursorBall"));
    SP<CursorBallConfiguration> cbc =
      dynamic_cast <CursorBallConfiguration *> (&*crsv->getConfiguration());
    cbc->setVisibleRadius (getVisibleRadius () * 0.5);
    initializeSlot (markerName (c), crsv);
  }
  deref ();
}

SP<ConstantRecursiveSlotValue> XYZCursorBallConfiguration::getAxisMarker
(char axisName)
{
  return ConstantRecursiveSlotValue::getSlotValue (this,
						   markerName (axisName));
}

SP<const ConstantRecursiveSlotValue> XYZCursorBallConfiguration::getAxisMarker
(char axisName)
  const
{
  return ConstantRecursiveSlotValue::getSlotValue (this,
						   markerName (axisName));
}

void XYZCursorBallConfiguration::setAxisMarker
(char axisName, SP<ConstantRecursiveSlotValue> value)
{
  ConstantRecursiveSlotValue::setSlotValue (this,
					    markerName (axisName),
					    value);
}

SP<Configuration> XYZCursorBallConfiguration::copy () const {
  return NEW (XYZCursorBallConfiguration (*this));
}

bool XYZCursorBallConfiguration::hasTheSameTypeAs (const Configuration *c)
  const
{
  return 0 != dynamic_cast <const XYZCursorBallConfiguration *> (c);
}
