// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __Configurable_h__
#include "Configurable.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __TransformConfiguration_h__
#include "TransformConfiguration.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __CursorBall_h__
#include "CursorBall.h"
#endif

#ifndef __OL_h__
#include "OL.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __CursorBallManager_h__
#include "CursorBallManager.h"
#endif

#ifndef __Matrix4_h__
#include "Matrix4.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __Canvas_h__
#include "Canvas.h"
#endif

namespace {
  class TransformCursorBallRHScreen
    : public Factory
  {
  public:
    TransformCursorBallRHScreen ()
      : Factory ("TransformCursorBallRHScreen")
    {}
    SP<Configuration> defaultConfiguration () const {
      return NEW (TransformConfiguration ());
    }
    String getPrettyName (const Configuration *c) const {
      (void) c;
      return "move the Cursor Ball";
    }
    SP<Configurable> makeIt (SP<Configuration> c) const {
      const SP<TransformConfiguration> tc =
	dynamic_cast <TransformConfiguration *> (&*c);
      assert (tc);
      const SP<TopLevel> top = tc->getTopLevel();
      SP<SceneGraph> sg = top->getSceneGraph ();
      // Don't copy here, otherwise moveTo will not update the global cursor
      // ball when it is configured to have a different size.
      OL<CursorBall> &cbl = CursorBallManager::getCursorBall (sg);
      // The center is probably the location of the CursorBall, but we don't
      // assume that.  Note that the CursorBall's position and rotation are in
      // world coordinates, but the tc means screen coordinates.
      SP<Canvas> canvas = top->getCanvas ();
      cbl->moveTo (cbl,
		   canvas->transformRHScreenToWorld
		   (tc->getMatrix () *
		    canvas->transformWorldToRHScreen (cbl->getPosition())),
		   canvas->transformRHScreenToWorld
		   (tc->getRotation () *
		    canvas->transformWorldToRHScreen (cbl->getRotation())));
      return NEW (Action ());
    }
  };
  static const bool useless =
  (FactoryTable::store ("TransformAction",
			NEW (TransformCursorBallRHScreen ())),
   true);
}
