// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __CursorBallManager_h__
#define __CursorBallManager_h__

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __OL_h__
#include "OL.h"
#endif

class RecursiveSlotValue;
class SceneGraph;
class CursorBall;
class CursorBallConfiguration;

class CursorBallManager {
public:
  // We need to have the configuration for the cursor ball, so commands that
  // manipulate the cursor ball can offer the user the chance to change it.
  static SP<RecursiveSlotValue> getCursorRSV ();
  static void setCursorRSV (SP<RecursiveSlotValue> rsv);
  // This method needs to know the scene graph when it is called the first
  // time because we'll be creating the cursorball then.
  // If you're going to use CursorBall::moveTo or CursorBall::updateFromConf,
  // make sure you're passing in the reference returned by getCursorBall, not a
  // copy of it.
  static OL<CursorBall> &getCursorBall (SP<SceneGraph> sg);
};
#endif

