// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __CursorBallManager_h__
#include "CursorBallManager.h"
#endif

#ifndef __CursorBall_h__
#include "CursorBall.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __CursorBallConfiguration_h__
#include "CursorBallConfiguration.h"
#endif

#ifndef __OL_h__
#include "OL.h"
#endif

namespace {
  OL<CursorBall> theBall;
  // theRSV is good to add to configurations of commands that manipulate the
  // cursorball.  This starts as zero so we can function even if this
  // translation unit is initialized before the CursorBall and XYZCursorBall
  // translation units.
  SP<RecursiveSlotValue> theRSV = 0;
  // The factory last time we created a cursorball.  If this is different from
  // the current factory in theRSV, then we have to make a new one.
  SP<const Factory> theFactory = 0;
  void deallocate () {
    // theBall contains no references to allocated memory, so nothing to do for
    // it.
    theRSV = 0;
    theFactory = 0;
  }
  bool useless = (MemoryUtil::registerDeallocator (deallocate), true);
};

SP<RecursiveSlotValue> CursorBallManager::getCursorRSV () {
  if (0 == theRSV) {
    theRSV = NEW (RecursiveSlotValue ("CursorBall", "XYZCursorBall"));
  }
  return theRSV;
}

void CursorBallManager::setCursorRSV (SP<RecursiveSlotValue> rsv) {
  theRSV = rsv;
}

OL<CursorBall> &CursorBallManager::getCursorBall (SP<SceneGraph> sg)
{
  if (theFactory && theFactory != getCursorRSV()->getFactory()
      && theBall.isValid()) {
    // If they changed factories, we need to generate a new CursorBall, so we
    // need to remove the old cursorball from the scene graph, which will cause
    // us to make a new one.
    theBall.deleteObject ();
  }
  if (!theBall.isValid ()) {
    theFactory = getCursorRSV()->getFactory ();
    SP<CursorBall> cb = dynamic_cast <CursorBall *> (&*getCursorRSV()->makeIt ());
    theBall = cb->insert (sg);
  }
  assert (theBall.isValid());
  assert (theBall.getSceneGraph () == sg);
  return theBall;
}
