// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __CursorBallConfiguration_h__
#include "CursorBallConfiguration.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __Vec3SlotValue_h__
#include "Vec3SlotValue.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __Color_h__
#include "Color.h"
#endif

#ifndef __QuaternionSlotValue_h__
#include "QuaternionSlotValue.h"
#endif

#ifndef __Quaternion_h__
#include "Quaternion.h"
#endif

namespace {
  String positionName () {
    return "Position";
  }
  String rotName () {
    return "Rotation";
  }
}

CursorBallConfiguration::CursorBallConfiguration ()
{
  ref ();
  initializeSlot (positionName (), NEW (Vec3SlotValue (Vec3 (0, 0, 0))));
  initializeSlot (rotName(), NEW (QuaternionSlotValue (Quaternion ())));
  setMaterial (Color (0, 0.8, 0, 1));
  setVisibleRadius (0.3);
  deref ();
}

Vec3 CursorBallConfiguration::getPosition () const {
  return Vec3SlotValue::getSlot (this, positionName ());
}

void CursorBallConfiguration::setPosition (const Vec3 &v) {
  Vec3SlotValue::setSlot (this, positionName (), v);
}

Quaternion CursorBallConfiguration::getRotation () const {
  return QuaternionSlotValue::getSlot (this, rotName());
}

void CursorBallConfiguration::setRotation (const Quaternion &q) {
  QuaternionSlotValue::setSlot (this, rotName(), q);
}

SP<Configuration> CursorBallConfiguration::copy () const {
  return NEW (CursorBallConfiguration (*this));
}

bool CursorBallConfiguration::hasTheSameTypeAs (const Configuration *c)
  const
{
  return 0 != dynamic_cast <const CursorBallConfiguration *> (&*c);
}
