// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __CursorBallActionConfiguration_h__
#define __CursorBallActionConfiguration_h__

#ifndef __OuterTransformConfiguration_h__
#include "OuterTransformConfiguration.h"
#endif

class CursorBallActionConfiguration
// This presents a configuration for the user to edit with a slot that is the
// cursorball managed by the CursorBallManger.  We don't bother providing a
// programmatic interface to manipulate that slot; instead, methods should just
// call the appropriate method on the CursorBallManager directly.
  : public OuterTransformConfiguration
{
public:
  CursorBallActionConfiguration ();
  bool hasTheSameTypeAs (const Configuration *c) const;
  SP<Configuration> copy () const;
  virtual SP<SlotValue> getSlot (const String &name);
  virtual SP<const SlotValue> getSlot (const String &name) const;
  virtual SP<BadSlotValue> setSlot (const String &name, SP<SlotValue> sv);
};

#endif
