// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __CursorBallActionConfiguration_h__
#include "CursorBallActionConfiguration.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __CursorBallManager_h__
#include "CursorBallManager.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __BadSlotValue_h__
#include "BadSlotValue.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

namespace {
  String ballConfName () {
    return "Cursor Ball Configuration";
  }
};

CursorBallActionConfiguration::CursorBallActionConfiguration () {
  initializeSlot (ballConfName (),
		  &*CursorBallManager::getCursorRSV ());
}

bool CursorBallActionConfiguration::hasTheSameTypeAs
(const Configuration *c) const
{
  return 0 != dynamic_cast <const CursorBallActionConfiguration *> (c);
}

SP<Configuration> CursorBallActionConfiguration::copy () const {
  // Default copy constructor is okay here.
  return NEW (CursorBallActionConfiguration (*this));
}

SP<SlotValue> CursorBallActionConfiguration::getSlot (const String &name) {
  if (ballConfName () == name) {
    return &*CursorBallManager::getCursorRSV ();
  } else {
    return Configuration::getSlot (name);
  }
}

SP<const SlotValue> CursorBallActionConfiguration::getSlot (const String &name)
  const
{
  if (ballConfName () == name) {
    return &*CursorBallManager::getCursorRSV ();
  } else {
    return Configuration::getSlot (name);
  }
}

SP<BadSlotValue> CursorBallActionConfiguration::setSlot (const String &name,
							 SP<SlotValue> sv) {
  if (ballConfName () == name) {
    assert (CursorBallManager::getCursorRSV()->hasTheSameTypeAs (sv));
    SP<RecursiveSlotValue> rsv = dynamic_cast <RecursiveSlotValue *> (&*sv);
    assert (rsv);
    CursorBallManager::setCursorRSV (rsv);
    return 0;
  } else {
    return Configuration::setSlot (name, sv);
  }
}
