// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __VectorSlotValue_h__
#define __VectorSlotValue_h__

#ifndef __SlotValue_h__
#include "SlotValue.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class Configuration;
class String;

class VectorSlotValue
  : public SlotValue
{
  struct VectorSlotValueData;
  VectorSlotValueData *m_data;
  friend class ConstantVectorSlotValue;
  // if the VectorSlotValue is constant, then the user cannot add or remove
  // elements by editing.   Since you can't add or remove elements there isn't
  // any use for the default element, so you'd might as well specify it as a
  // null pointer.  You can modify the individual elements, though.
  // Client code, in contrast, can modify a constant VectorSlotValue as freely
  // as a non-constant one.
  VectorSlotValue (SP<SlotValue> def,
		   const Dynavec <SP<SlotValue> > &values,
		   bool constantp);
public:
  ~VectorSlotValue ();
  VectorSlotValue (SP<SlotValue> def);
  VectorSlotValue (SP<SlotValue> def,
		   const Dynavec <SP<SlotValue> > &values);
  VectorSlotValue (const VectorSlotValue &v);
  bool hasTheSameTypeAs (const SlotValue *s) const;
  String unParse () const;
  void editSlotValue();
  SP<SlotValue> copy () const;
  int size() const;
  // Use setValue instead of a settable reference, so we can do some
  // consistency checking.
  const SP<SlotValue> &operator[] (int where);
  // Note that they can't set this, you have to use setValue.
  const SP<const SlotValue> operator[] (int where) const;
  void setValue (int where, SP<SlotValue> sv);
  void extendTo (int size);
  SP<SlotValue> getDefault () const;
  static const VectorSlotValue *getSlotValue (const Configuration *a_c,
					      const String &name);
  static VectorSlotValue *getSlotValue (Configuration *a_c,
					const String &name);
  static void setSlotValue (SP<Configuration> c,
			    const String &name,
			    SP<VectorSlotValue> rsv);
};

#endif
