// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __TypedVersionOfFactory_h__
#define __TypedVersionOfFactory_h__

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

template <class ConfClass, class ResultClass> class TypedVersionOfFactory
// Given an untyped factory, apply this constructor to generate an equivalent
// typed factory, assuming you've correctly chosen the configuration and result
// types of the untyped factory.
// This was originally used in a version of TypedRecursiveSlotValue, but I gave
// up on TypedRecursiveSlotValue for now, so this is presently unused.
  : public TypedFactory <ConfClass, ResultClass>
{
  SP<Factory> m_f;
public:
  TypedVersionOfFactory (const Factory *f)
    : TypedFactory <ConfClass, ResultClass> (f->getName())
  {}
  SP<ConfClass> typedDefaultConfiguration () const {
    SP<Configuration> c = f->defaultConfiguration ();
    SP<ConfClass> c2 = dynamic_cast <ConfClass *> (&*c);
    assert (c2);
    return c2;
  }
  SP<ResultClass> makeIt (ConfClass *c) const {
    SP<Configurable> r1 = f->makeIt (&*c);
    SP<ResultClass> r2 = dynamic_cast <ResultClass *> (&*r1);
    // Getting a null for r2 is okay if r1 was null also.
    assert (r2 || !r1);
    return r2;
  }
};
#endif
