// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __TypedFactory_h__
#define __TypedFactory_h__

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __Configurable_h__
#include "Configurable.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

template <class ConfClass, class ResultClass> class TypedFactory
// Like Factory, except it knows the types of its configuration and the type
// that it produces, so you won't have to routinely change these with casts.
// Take a subclass of this to use it.
  : public Factory
{
public:
  TypedFactory (const String &name)
    : Factory (name)
  {}
  virtual SP<ConfClass> typedDefaultConfiguration () const = 0;
  SP<Configuration> defaultConfiguration () const {
    return &*typedDefaultConfiguration ();
  }
  virtual SP<ResultClass> makeIt (ConfClass *c) const = 0;
  SP<Configurable> makeIt (const SP<Configuration> c) const {
    SP<ConfClass> cc = dynamic_cast <ConfClass *> (&*c);
    assert (cc);
    return &*makeIt (cc);
  }
  // If you override the next one, you won't have to downcast the
  // configuration.
  virtual String typedGetPrettyName (const ConfClass *c) const {
    return Factory::getPrettyName (c);
  }
  String getPrettyName (const Configuration *c) const {
    SP<const ConfClass> c1 = dynamic_cast <const ConfClass *> (c);
    assert (c1);
    return typedGetPrettyName (c1);
  }
};
#endif
