// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "TextConfigurationEditor.h"

#ifndef __SlotValue_h__
#include "SlotValue.h"
#endif

#ifndef __StreamUtil_h__
#include "StreamUtil.h"
#endif

#ifndef __VecUtil_h__
#include "VecUtil.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __iostream_h__
#include <iostream.h>
#define __iostream_h__
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __BadSlotValue_h__
#include "BadSlotValue.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

namespace {
  void pushSlotHeaders (Dynavec <String> &v) {
    v.push ("Field name");
    v.push ("Field type");
    v.push ("Field value");
  }
  
  void pushSlotData (Dynavec <String> &v,
		     Configuration &c,
		     const String &name) {
    v.push (name);
    SP<SlotValue> sv = c.getSlot (name);
    v.push (sv->typeName ());
    v.push (sv->unParse ());
  }
  
  void promptRead (const char *prompt, int &result, int max) {
    for (;;) {
      StreamUtil::promptRead (prompt, result);
      if (result < 0 || result >= max) {
	cout << "Field number out of bounds.  Try again." << endl;
      } else {
	break;
      }
    }
  }

  // Return true iff there is something to edit.
  bool printSlots (Configuration &c,
		   // Next argument is purely output.
		   Dynavec <String> &lineNumToSlotName) {
    Dynavec <String> slots = c.getSlots ();
    VecUtil::sort (slots);
    lineNumToSlotName.extendTo (0);
    // Start numbering the slots from 1.  0 is special.
    lineNumToSlotName.push ("");
    bool result;
    {
      Dynavec <Dynavec <String> > tableau;
      tableau.push (Dynavec <String> ());
      tableau[0].push ("Number");
      pushSlotHeaders (tableau [0]);
      for (int i = 0; i < slots.size(); i++) {
	const int lineNo = lineNumToSlotName.size();
	lineNumToSlotName.push (slots [i]);
	const int where = tableau.size();
	tableau.push (Dynavec<String> ());
	tableau[where].push (lineNo);
	pushSlotData (tableau[where], c, slots [i]);
      }
      if (tableau.size () > 1) {
	cout << "The configuration has these read/write fields:" << endl;
	StreamUtil::printTableau (cout, tableau);
	result = true;
      } else {
	cout << "The configuration has no fields that can be changed." << endl;
	result = false;
      }
    }
    return result;
  }
}
  
void TextConfigurationEditor::edit (SP <Configuration> c) {
  for (;;) {
    Dynavec <String> lineNumToSlotName;
    const bool toEdit = printSlots (*c, lineNumToSlotName);
    if (!toEdit) {
      cout << "Nothing to edit, so we're done."<<endl;
      break;
    }
    int fieldno;
    promptRead
      ("Give the number of a field to edit, or press 0 to exit: ",
       fieldno,
       lineNumToSlotName.size());
    if (0 == fieldno) break;
    const String slotName = lineNumToSlotName[fieldno];
    for (;;) {
      SP<SlotValue> oldSlotValue = c->getSlot(slotName)->copy();
      c->getSlot(slotName)->editSlotValue ();
      SP<BadSlotValue> gripe =
	c->setSlot (slotName,c->getSlot (slotName));
      if (!gripe) break;
      {
	SP<BadSlotValue> tmpGripe = c->setSlot(slotName, oldSlotValue);
	(void) tmpGripe;  // Avoid unused variable in NDEBUG code.
	assert (!tmpGripe);
      }
      cout << "The "<<slotName<<" slot should be "<<gripe->getWhy()
	   <<".  Try again."<<endl;
    }
  }
}
