// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __SlotValue_h__
#define __SlotValue_h__

#ifndef __Refcount_h__
#include "Refcount.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class BadSlotValue;
class String;

// The value and type for a slot in a configuration.  To determine the
// type, do a dynamic_cast.
// These are changed in place by editSlotValue.
class SlotValue
  : public Refcount
{
  struct SlotValueData;
  SlotValueData *m_data;
protected:
  // Only subclasses can construct.
  SlotValue (const String &typeName);
public:
  String typeName () const;
  virtual bool hasTheSameTypeAs (const SlotValue *s) const = 0;
  // Convert it to a string, for printing.
  virtual String unParse () const = 0;
  // The present slot value is the old value.  Do terminal dialogue
  // via cin and cout to edit the slot value, and return a pointer to
  // this.
  virtual void editSlotValue() = 0;
  virtual ~SlotValue ();
  // Copy a SlotValue.
  SlotValue (const SlotValue &sv);
  virtual SP<SlotValue> copy () const = 0;
  // Return null if the present value of the slot is okay, otherwise
  // return a BadSlotValue that says what is wrong.  Call this after
  // calling the constructor, and if this complains, setSlotValue
  // should relay the complaint.  By default, there is no constraint.
  // For example, PositiveIntSlotValue has a constraint that the
  // integer should be positive.
  virtual SP<BadSlotValue> constrain ();
};

#endif
