// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "SlotValue.h"

#ifndef __BadSlotValue_h__
#include "BadSlotValue.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

struct SlotValue::SlotValueData {
  // The name of the type, for use in generic UI's.  
  String m_typeName;
};

SlotValue::SlotValue (const String &typeName)
  : m_data (NEW (SlotValueData ()))
{
  m_data->m_typeName = typeName;
}

SlotValue::SlotValue (const SlotValue &sv)
  : Refcount (sv),
    m_data (NEW (SlotValueData ()))
{
  m_data->m_typeName = sv.m_data->m_typeName;
}

String SlotValue::typeName () const {
  return m_data->m_typeName;
}

SlotValue::~SlotValue ()
{
  assert (m_data);
  delete m_data;
  m_data = 0;
}

SP<BadSlotValue> SlotValue::constrain () {
  return 0;
};
