// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __ScalarSlotValue_h__
#define __ScalarSlotValue_h__

#ifndef __StreamUtil_h__
#include "StreamUtil.h"
#endif

#ifndef __SlotValue_h__
#include "SlotValue.h"
#endif

#ifndef __BadSlotValue_h__
#include "BadSlotValue.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __iostream_h__
#include <iostream.h>
#define __iostream_h__
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

template <class ScalarType, const char **name> class ScalarSlotValue : public SlotValue {
  ScalarType m_value;
protected:
  ScalarSlotValue (const ScalarSlotValue &s)
    : SlotValue (s), m_value (s.m_value)
  {}
public:
  typedef ScalarType DomainType;
  static String getDefaultTypeName () {
    return *name;
  }
  ScalarSlotValue (ScalarType value, const String &typeName)
    : SlotValue (typeName), m_value (value)
  {}
  ScalarSlotValue (ScalarType value)
    : SlotValue (*name), m_value (value)
  {}
  ScalarType getValue () const { return m_value; }
  bool hasTheSameTypeAs (const SlotValue *s) const {
    return 0 != dynamic_cast <const ScalarSlotValue *> (s);
  }
  String unParse () const {
    return String (m_value);
  }
  void editSlotValue () {
    // See comments in BoolSlotValue.h for why we have String
    // (m_value) on next line, instead of just m_value.
    cout << "The old value of the slot is " << String (m_value) << "." << endl;
    StreamUtil::promptReadNew (m_value);
  }
  SP<SlotValue> copy () const {
    return NEW (ScalarSlotValue (*this));
  }
  static ScalarType getSlot (const Configuration *a_c,
			     const String &slotName) {
    SP<const Configuration> c = a_c;
    SP<const SlotValue> slot = c->getSlot (slotName);
    const ScalarSlotValue *islot =
      dynamic_cast <const ScalarSlotValue *> (&*slot);
    assert (islot);
    return islot->getValue();
  }
  static void setSlot (Configuration *a_c,
		       const String &slotName,
		       ScalarType b) {
    SP<Configuration> c = a_c;
    SP<BadSlotValue> bad = c->setSlot (slotName, NEW (ScalarSlotValue (b)));
    assert (!bad);
  }
};
#endif
