// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//
#ifndef __MenuSlotValueChoices_h__
#define __MenuSlotValueChoices_h__

#ifndef __Refcount_h__
#include "Refcount.h"
#endif

class String;
class MenuSlotValueChoices
// The choices available in a MenuSlotValue. 
  : public Refcount
{
  struct MenuSlotValueChoicesData;
  MenuSlotValueChoicesData *m_data;
public:
  // addChoice adds a choice to the menu.  If shortName is already on the menu,
  // this has no effect.
  void addChoice (const String &shortName, const String &prettyName);
  const String &getPrettyName (int pos) const;
  const String &getShortName (int pos) const;
  // size () returns the number of choices.
  int size () const;
  // Returns -1 if the name is not found, or the position otherwise.
  int lookUpShortName (const String &shortName) const;
  MenuSlotValueChoices ();
  ~MenuSlotValueChoices ();
  int generation () const;
};

#endif
