// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __MenuSlotValue_h__
#define __MenuSlotValue_h__

#ifndef __SlotValue_h__
#include "SlotValue.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class MenuSlotValueChoices;
class Configuration;
class MenuSlotValue
// A SlotValue that is a simple multiple choice
// The requirements are driven by the need to allow choosing a drawing method
// from a plugin:
// We need to have the list of choices as a separate object, so we can have
// many MenuSlotValue's choosing from the same choices, and maintain that list
// of choices in some central place.  We need to be able to support adding to
// the list of choices, but it is not very important to support removing from
// the list of choices.
// We need to export a generation number so we can cache things where the cache
// becomes invalid when the number of choices in the menu changes.
// We need to have both pretty strings that are displayed on the menu and short
// strings that are returned to the program.
  : public SlotValue
{
  struct MenuSlotValueData;
  MenuSlotValueData *m_data;
public:
  int getIntChoice () const;
  String getShortStringChoice () const;
  String getPrettyStringChoice () const;
  // Next two assert that the value is in bounds.  We don't try to do any
  // meaningful error detection for bad choices generated from code.
  void setIntChoice (int newValue);
  void setShortStringChoice (const String &choice);
  SP<MenuSlotValueChoices> getChoices ();
  SP<const MenuSlotValueChoices> getChoices () const;
  // The default choice is choice 0, which is the first one in the choices
  // list.  Our integrity check verifies that the choice is not out of bounds
  // for the choices list.  We don't do the integrity check in the constructor,
  // so you can call the constructor with an empty list of choices. It's
  // important in that case to add some choices before calling getIntChoice,
  // getShortStringChoice, getPrettyStringChoice, or editSlotValue.
  MenuSlotValue (MenuSlotValueChoices *choices);
  ~MenuSlotValue ();
  MenuSlotValue (const MenuSlotValue &msv);
  void editSlotValue ();
  bool hasTheSameTypeAs (const SlotValue *s) const;
  SP<SlotValue> copy () const;
  String unParse () const;
  static SP<MenuSlotValue> getSlotValue (Configuration *c,
					 const String &name);
  static SP<const MenuSlotValue> getSlotValue (const Configuration *c,
					       const String &name);
  int generation () const;
};

#endif
