// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __FactoryTable_h__
#define __FactoryTable_h__

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

class String;
class Factory;

// This is the global table that keeps track of which factories
// implement which protocols.
class FactoryTable {
 public:
  // Register a factory; in other words, store the information that
  // this factory implements its protocol, so we can get the factory
  // back later when we call lookup on it's protocol.  Registering a
  // factory that is already registered has no effect.
  static void store (const String &protocol, SP<Factory> f);
  // Return a list of factories that implement the given protocol.
  // If the protocol has never been heard of before, you get an empty
  // list.
  static Dynavec <SP<Factory> > load (const String &protocol);
  // Find the factory with a specific name.  Return null if there
  // isn't one.  Good for creating default configurations without
  // creating dependencies on header files.
  static SP<Factory> load (const String &protocol, const String &factoryName);
  // Say that subclass is a subclass of superclass.  Then objects in
  // the subclass should register themselves as such, and when we ask
  // for all of the factories in the superclass, it will include the
  // factories in the subclass.
  static void registerSubclass (const String &subclass,
				const String &superclass);
};

#endif
