// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Factory_h__
#define __Factory_h__

#ifndef __Refcount_h__
#include "Refcount.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class String;
class Configurable;
class Configuration;

class Factory
  : public virtual Refcount
{
  class FactoryData;
  // The real instance data is hidden behind this pointer, so
  // implementation changes that aren't interface changes won't
  // require the users to recompile.
  FactoryData *m_data;
 protected:
  // Can only construct this from a subclass.
  Factory (const String &name);
 public:
  ~Factory ();
  String getName () const;
  // The default configuration for this Factory.  This should be
  // constructed afresh each time defaultConfiguration is called, so
  // the configuration can be edited in place without corrupting the
  // defaultConfiguration that would be returned the next time.
  virtual SP<Configuration> defaultConfiguration () const = 0;
  // The guy who wants to use the Factory has to dynamic_cast the
  // result from makeIt to the class that the factory implements.
  // Classes may want to update their configuration when they are made
  // or when they are run as a means to communicate with the user, so
  // pass in a non-const Configuration.  SubsetStorage is an example.
  virtual SP<Configurable> makeIt (SP<Configuration> c) const = 0;
  SP<Configurable> makeIt () const;
  // getPrettyName is different from getName in that it gets the right to look
  // at the Configuration that will eventually be passed to makeIt.  This name
  // is meant to be shown to the user.  It may not stay constant, so it should
  // not be used as a key to a hash table.  The default implementation just
  // returns the value returned by getName.
  virtual String getPrettyName (const Configuration *c) const;
};

#endif
