// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "Factory.h"

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __Configurable_h__
#include "Configurable.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

class Factory::FactoryData {
public:
  // The protocol that this factory implements.  PhysicsObject, for instance.
  //  const String m_protocol;
  // The name of this factory.  BrennerAtom, BoringBall, or
  // BouncingBall, for instance.  To minimize confusion, this should
  // be the same as the name of the subclass of Configurable that is
  // returned by makeIt.  For each protocol, we have a bunch of
  // factories that implement the protocol, and they must all have
  // distinct names.  You may want to put a personal prefix on the factory
  // name, like "Tim_BoringBall", to prevent collisions.
  const String m_name;
  FactoryData (const String &name)
  : m_name (name)
  {}
};

Factory::Factory (const String &name)
  : m_data (NEW (FactoryData (name)))
{}

Factory::~Factory () {
  assert (m_data);
  delete m_data;
  m_data = 0;
}

String Factory::getName () const {
  return m_data->m_name;
}

// The factory can implment multiple protocols now, so we have to get
// rid of this method.
//String Factory::getProtocol () const {
//  return m_data->m_protocol;
//}

SP<Configurable> Factory::makeIt () const
{
  return makeIt (&*defaultConfiguration ());
}

String Factory::getPrettyName (const Configuration *c) const {
  (void) c;
  return getName ();
}
