// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __ConstantRecursiveSlotValue_h__
#include "ConstantRecursiveSlotValue.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __BadSlotValue_h__
#include "BadSlotValue.h"
#endif

#ifndef __iostream_h__
#include <iostream.h>
#define __iostream_h__
#endif

ConstantRecursiveSlotValue::ConstantRecursiveSlotValue
(const String &protocol, Factory *f)
  : RecursiveSlotValue (protocol, f, true)
{}

namespace {
  SP<Factory> safeGetFactory (const String &protocol, const String &factory) {
    SP<Factory> result = FactoryTable::load (protocol, factory);
    if (!result) {
      cerr << "Could not find factory " << factory << " in protocol "
	   << protocol << endl;
      abort ();
    }
    return result;
  }
}

ConstantRecursiveSlotValue::ConstantRecursiveSlotValue
(const String &protocol, const String &factory)
  : RecursiveSlotValue (protocol, safeGetFactory (protocol, factory), true)
{}

SP<SlotValue> ConstantRecursiveSlotValue::copy () const {
  return NEW (ConstantRecursiveSlotValue (*this));
}

String ConstantRecursiveSlotValue::unParse () const {
  String result = getConfiguration()->unParse ();
  if ("" == result) {
    return RecursiveSlotValue::unParse ();
  } else {
    return result;
  }
}

SP<ConstantRecursiveSlotValue> ConstantRecursiveSlotValue::getSlotValue
(Configuration * a_c, const String &name)
{
  SP<Configuration> c = a_c;
  SP<SlotValue> slot = c->getSlot (name);
  ConstantRecursiveSlotValue *islot =
    dynamic_cast <ConstantRecursiveSlotValue *> (&*slot);
  assert (islot);
  return islot;
}

SP<const ConstantRecursiveSlotValue> ConstantRecursiveSlotValue::getSlotValue
(const Configuration *a_c, const String &name)
{
  SP<const Configuration> c = a_c;
  SP<const SlotValue> slot = c->getSlot (name);
  const ConstantRecursiveSlotValue *islot =
    dynamic_cast <const ConstantRecursiveSlotValue *> (&*slot);
  assert (islot);
  return islot;
}

void ConstantRecursiveSlotValue::setSlotValue (SP<Configuration> c,
		   const String &name,
		   SP<ConstantRecursiveSlotValue> rsv)
{
  SP<BadSlotValue> b = c->setSlot (name, &*rsv);
  assert (!b);
}

