// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __ColorSlotValue_h__
#define __ColorSlotValue_h__

#ifndef __SlotValue_h__
#include "SlotValue.h"
#endif

#ifndef __Color_h__
#include "Color.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

class ColorSlotValue : public SlotValue {
  Color m_value;
protected:
  ColorSlotValue (const ColorSlotValue &csv);
public:
  ColorSlotValue (const Color &m);
  ColorSlotValue (Float r, Float g, Float b, Float a);
  Color getValue () const;
  String unParse () const;
  bool hasTheSameTypeAs (const SlotValue *) const;
  void editSlotValue ();
  SP<SlotValue> copy () const;
  static void setSlot (SP<Configuration> conf, const String &name,
			const Color &value);
  static Color getSlot (SP<const Configuration> conf, const String &name);
};
#endif
