// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "ColorSlotValue.h"

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __SlotValue_h__
#include "SlotValue.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __StreamUtil_h__
#include "StreamUtil.h"
#endif

#ifndef __Color_h__
#include "Color.h"
#endif

#ifndef __BadSlotValue_h__
#include "BadSlotValue.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

ColorSlotValue::ColorSlotValue (const ColorSlotValue &v)
  : SlotValue (v),
    m_value (v.m_value)
{}

ColorSlotValue::ColorSlotValue (Float r, Float g, Float b, Float a)
  : SlotValue ("ColorSlotValue"),
    m_value (r, g, b, a)
{}
  
Color ColorSlotValue::getValue () const {
  return m_value;
}

ColorSlotValue::ColorSlotValue (const Color &v)
  : SlotValue ("ColorSlotValue"),
    m_value (v)
{}

bool ColorSlotValue::hasTheSameTypeAs (const SlotValue *s) const {
  return 0 != dynamic_cast <const ColorSlotValue *> (s);
}

String
ColorSlotValue::unParse () const {
  return String("(")+m_value[0]+", "+m_value[1]+", "+m_value[2]+", "+
    m_value[3]+")";
}

void ColorSlotValue::editSlotValue() {
  StreamUtil::promptRead ("What red value do you want?  ", m_value[0]);
  StreamUtil::promptRead ("What green value do you want?", m_value[1]);
  StreamUtil::promptRead ("What blue value do you want? ", m_value[2]);
  StreamUtil::promptRead ("What alpha value do you want?", m_value[3]);
}

SP<SlotValue> ColorSlotValue::copy () const {
  return NEW (ColorSlotValue (*this));
}

void ColorSlotValue::setSlot (SP<Configuration> conf, const String &name,
			       const Color &value) {
  SP<BadSlotValue> bad = conf->setSlot (name, NEW (ColorSlotValue (value)));
  assert (!bad);
}

Color ColorSlotValue::getSlot (SP<const Configuration> conf,
				  const String &name) {
  SP<const SlotValue> slot = conf->getSlot (name);
  SP<const ColorSlotValue> csv =
    dynamic_cast <const ColorSlotValue *> (&*slot);
  assert (csv);
  return csv->getValue();
}
