// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __BadSlotValue_h__
#define __BadSlotValue_h__

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __Refcount_h__
#include "Refcount.h"
#endif

class BadSlotValue : public Refcount {
  // The reason why should be a noun phrase or adjective saying what
  // the slot should have been.  For instance, if it should have
  // been a positive integer, use "postitive" or "a postitive
  // integer".  This way we can construct error messages like "The
  // blatz field should have been a positive integer".
  const String m_why;
 public:
  inline BadSlotValue (const String &why)
    : m_why (why) {}
  inline String getWhy () const { return m_why; }
};

#endif
